/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.structure;

import LegendaryCardMaker.CustomCardMaker.ALIGNMENT;
import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.structure.CustomElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.LineMetrics;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.SwingUtilities;

public class ElementText
extends CustomElement {
    public String defaultValue;
    public CustomElement linkedElement;
    public ALIGNMENT alignment = ALIGNMENT.CENTER;
    public boolean allowChange;
    public int x;
    public int y;
    public Color colour;
    public boolean drawUnderlay;
    public int blurRadius;
    public boolean blurDouble;
    public int blurExpand;
    public Color blurColour;
    public int textSize;
    public String fontName;
    public int fontStyle;
    public boolean uppercase;
    public String value;

    @Override
    public void drawElement(Graphics2D g) {
        if (this.getValue() != null && this.visible) {
            BufferedImage bi = new BufferedImage(CustomCardMaker.cardWidth, CustomCardMaker.cardHeight, 2);
            Graphics2D g2 = this.getGraphics(bi);
            g2 = this.setGraphicsHints(g2);
            if (this.colour != null) {
                g2.setColor(this.colour);
            }
            Font font = null;
            try {
                font = Font.createFont(0, new File("Sylfaen.ttf"));
                font = font.deriveFont((float)this.textSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                font = new Font("Sylfaen", 0, this.textSize);
            }
            if (this.fontName != null) {
                font = new Font(this.fontName, this.fontStyle, this.textSize);
            }
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics(font);
            int stringLength = SwingUtilities.computeStringWidth(metrics, this.getValueForDraw());
            g2 = this.setGraphicsHints(g2);
            int newx = this.x;
            if (this.alignment.equals((Object)ALIGNMENT.CENTER)) {
                newx = this.x - stringLength / 2;
            }
            if (this.alignment.equals((Object)ALIGNMENT.RIGHT)) {
                newx = this.x - stringLength;
            }
            LineMetrics lm = metrics.getLineMetrics(this.getValueForDraw(), g2);
            int yModified = this.y + (int)((lm.getAscent() - lm.getDescent()) / 2.0f);
            g2.drawString(this.getValueForDraw(), newx, yModified);
            if (this.drawUnderlay) {
                this.drawUnderlay(bi, g2, 2, 0, 0, this.blurRadius, this.blurDouble, this.blurExpand, this.blurColour);
            }
            g2.drawString(this.getValueForDraw(), newx, yModified);
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    private String getValueForDraw() {
        if (this.uppercase && this.getValue() != null) {
            return this.getValue().toUpperCase();
        }
        return this.getValue();
    }

    @Override
    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    @Override
    public String generateOutputString(boolean fullExport) {
        String str = "";
        if (this.value != null) {
            str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";value;" + this.value + "\n";
        }
        str = String.valueOf(str) + "CUSTOMVALUE;" + this.name + ";visible;" + this.visible + "\n";
        return str;
    }
}

